#version 330
#extension GL_EXT_gpu_shader4 : enable
//Escher Gradient FieldMod01.fsh  by  gltracy
//https://www.shadertoy.com/view/MttGWs
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// written by @ephtracy
#define PI (3.14159265)

vec2 escher( vec2 p, float es ) {
	p = vec2( log( length( p ) ), atan( p.y, p.x ) ) - iTime * 0.1;
    
	float r = es / ( 2.0 * PI );

	p += p.yx * vec2( r, -r );

	p.x = mod( p.x, es ) - 0.25 * es;

    p = exp( p.x * 0.465 ) * vec2( cos( p.y ), sin( p.y ) ); // <-- remove 0.465
    
   	p *= exp( ceil( log( max( abs( p.x ), abs( p.y ) ) ) ) ); // <-- droste
    
	return p;
}

vec2 uvMap( vec2 v ) {
    return escher( ( v - iResolution.xy * 0.5 ) / ( iResolution.y * 0.65 ), 1.0 );
}

float draw( float d, vec2 g, float size, float sharp )	{
    return smoothstep( size * sharp, size, d / length( g ) );
}

///////////////////////////////////////////////////
float map( vec2 v ) {
    v = uvMap( v );
    return ( v.x * v.x - v.y * v.y );
}

vec2 gradient( vec2 v ) {
    const float s = 1.0;
    float dx = ( map( v + vec2( s, 0.0 ) ) - map( v - vec2( s, 0.0 ) ) );
    float dy = ( map( v + vec2( 0.0, s ) ) - map( v - vec2( 0.0, s ) ) ); 
    return vec2( dx, dy ) / ( s + s );
}

float map_grad( vec2 v ) {
   	v = uvMap( v );
    return ( log(abs(v.x) + 0.00001) + log(abs(v.y) + 0.00001) );
}

vec2 gradient_grad( vec2 v ) {
    const float s = 0.1;
    float dx = ( map_grad( v + vec2( s, 0.0 ) ) - map_grad( v - vec2( s, 0.0 ) ) );
    float dy = ( map_grad( v + vec2( 0.0, s ) ) - map_grad( v - vec2( 0.0, s ) ) ); 
    return vec2( dx, dy ) / ( s + s );
}

///////////////////////////////////////////////////
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
void main (void)
{
	vec2 u = gl_FragCoord.xy;
    
    vec3 final = vec3( 0.0 );
  
    
    // gradient field
    {
        float d = map_grad( u );
        vec2 g = gradient_grad( u );
        
        vec3 color = vec3( 1.0, 0.6, 0.3 ) * (max(1.0 - abs(d), 0.0)+0.3) * 0.4;
      	
        final = mix( final, color, draw( abs(mod( d, 0.1) - 0.05), g, 1.0, 0.5 ) );
    }
    
    // level set
    {
        float d = map( u );
    	vec2 g = gradient( u );
        
        vec3 color = vec3( 1.0, 0.6, 0.3 ) * (max(1.0 - abs(d), 0.0)+0.3);
    	
        final = mix( final, color, 1.0 - draw( abs(mod(d, 0.2) - 0.1), g, 1.8, 0.5 ) );
    }
     
	gl_FragColor = vec4( 1.0 - final, 1.0 );
}